
      program com_test_w

c     Prints CoM values for all satellites and system configurations
c     matching input criteria provided interactively

      implicit none

      character sat*1
      character(len=11) version
      integer i, istn, iy, doy, wave,
     .        i_lg1, i_lg2, i_et1, i_las, i_str, i_aji, i_la2,
     .        err
      double precision cm_lg1(20), cm_lg2(20), cm_et1(20),
     .                 cm_las(20), cm_str(20), cm_aji(20), cm_la2(20)

      call com_table_version(10, 'l', version)
      print *, 'LG1 table version: ', version
      call com_table_version(10, 'm', version)
      print *, 'LG2 table version: ', version
      call com_table_version(10, 'e', version)
      print *, 'ET1 table version: ', version
      call com_table_version(10, 's', version)
      print *, 'LAS table version: ', version
      call com_table_version(10, 'r', version)
      print *, 'STR table version: ', version
      call com_table_version(10, 'a', version)
      print *, 'AJI table version: ', version
      call com_table_version(10, 'u', version)
      print *, 'LA2 table version: ', version

      do
         print *
         print *, 'sta year doy wave'
         read(*,*) istn, iy, doy, wave

         call com6(10, istn, iy, doy, 'l', wave, i_lg1, cm_lg1, err)
            call print_error_msg('LAGEOS-1', err)
         call com6(10, istn, iy, doy, 'm', wave, i_lg2, cm_lg2, err)
            call print_error_msg('LAGEOS-2', err)
         call com6(10, istn, iy, doy, 'e', wave, i_et1, cm_et1, err)
            call print_error_msg('Etalon', err)
         call com6(10, istn, iy, doy, 's', wave, i_las, cm_las, err)
            call print_error_msg('LARES', err)
         call com6(10, istn, iy, doy, 'r', wave, i_str, cm_str, err)
            call print_error_msg('Starlette', err)
         call com6(10, istn, iy, doy, 'a', wave, i_aji, cm_aji, err)
            call print_error_msg('Ajisai', err)
         call com6(10, istn, iy, doy, 'u', wave, i_la2, cm_la2, err)
            call print_error_msg('LARES-2', err)
         print *, '  LG1    LG2     ET    LAS    STR    AJI    LA2'

         do i=1,max(i_lg1, i_lg2, i_et1, i_las, i_str, i_aji, i_la2)
            print '(7(f7.1))', cm_lg1(i), cm_lg2(i), cm_et1(i),
     .                         cm_las(i), cm_str(i), cm_aji(i),
     .                         cm_la2(i)
         end do
      enddo

      end program


      subroutine print_error_msg(sat, err)
         implicit none
         character(len=*) sat
         integer err

         if (err == 0) then
            return
         else if (err == 1) then
            print '("Error retrieving CoM,", a10)', sat
         else if (err == 2) then
            print '("Error retrieving CoM. Default used:", a10)', sat
         endif
      end subroutine
